% Script-File Chi2TestLotto.m
%
% Aufruf:  Chi2TestLotto
%
% bungsaufgabe:  Chi-Quadrat-Test fr sterreichische Lottozahlen
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 13.11.2002

% Lotto-Statistik

zahl = [1,   2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, ...
        16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, ...
        31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45];
    
hfg =  [147, 130, 163, 150, 156, 143, 170, 147, 136, 151, 148, 130, 138, 136, 141,...
        162, 147, 140, 135, 145, 143, 141, 140, 145, 141, 172, 155, 157, 151, 158,...
        156, 142, 144, 128, 133, 153, 152, 139, 164, 139, 140, 151, 175, 154, 142];

alpha = 0.01;                        % Signifikanzniveau
K = length(hfg)                      % Zahl der "Klassen"
thfg = ones(size(hfg))*sum(hfg)/K;   % Vektor der theoretischen absoluten Hufigkeiten

% Bestimmung des kritischen Werts

c = chi2invB(1-alpha, K-1)

% Berechnung der Testvariablen

chi2 = sum(((hfg-thfg).^2)./hfg)

% Ergebnis des Tests

TestErg = ~(chi2<=c)