% Script-File DreiGaussKurven.m
%
% Aufruf:  DreiGaussKurven
%
% Beispiel fr die Normal-Verteilung
% Grafische Darstellung fr drei verschiedene Varianzen
% 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.02
% Datum: 14.8.2004

x = (-10:0.01:10);        % Wertebereich von der Zufallsvariablen
mu = 0;                   % Parameter der Normalverteilung
sigma1 = 1; sigma2 = 2; sigma3 = 3;
                          % Berechnung der Verteilungsdichten 
dichte1 = normpdfB(x, mu, sigma1); 
dichte2 = normpdfB(x, mu, sigma2);     
dichte3 = normpdfB(x, mu, sigma3);     

                          % grafische Darstellung
plot(x, dichte1,'r-', x, dichte2,'b-', x, dichte3,'g-','LineWidth',4);
set(gca, 'FontSize', 12);
xlabel('x');
ylabel('N(\mu,\sigma^2)(x)');
text(0.3, normpdfB(0.0, mu, sigma1)+0.02, '\sigma^2=1');
text(2.3, normpdfB(2.0, mu, sigma2)+0.02, '\sigma^2=4');
text(5.3, normpdfB(5.0, mu, sigma3)+0.02, '\sigma^2=9');
axis([-10,10,0,0.5])