function [ModW] = EmpModal2(stprob)
%
% Aufruf: [ModW] = EmpModal2(stprob)
%
% Berechnet den empirischen Modalwert einer Stichprobe. Die Berechnung beruht
% auf der Bestimmung der empirischen Verteilung fr die Stichprobe und hngt von der Wahl der
% Klassen ab, die durch den Vektor klmitten bestimmt werden.
%
% Dieser vektor muss ber eine GLOBALE VARIABLE bergeben werden!!
%
% Eingabeparameter:    stprob       Stichprobe
%
%
% Ausgabeparameter:    ModW         "empirischer" Modalwert
%
%
% Es werden sonst KEINE Fehleingaben abgefangen!!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 20.12.2003


% Klassenmitten (mssen ber globale Variable bergeben werden)

global klmitten

% (Klassen-)Hufigkeitsverteilung berechnen
    
[Hfg, X, emdist, cemdist] = distempStetig(stprob, klmitten, 0);

% Modalwert berechnen

[mx, ind] = max(emdist);
ModW = X(ind);