function [bsStat,varargout] = bootstrpB(anz,funct,data)
%
% Funktion bootstrpB
%
% Aufruf: [bsStat] = bootstrpB(anz,funct,data)
%
% Funktion zur Bestimmung einer bootstrap-Statistik.
% (vgl. Abschnitt 6.1.1)
%
% Diese Funktion hat gegenber der Statistics-Toolbox-Funktion bootstrp
% EINGESCHRNKTE Funktionalitt!
% Zugelassen sind nur Zeilen- oder Spaltenvektoren data als Stichprobe
% der Grundgesamtheit. Insbesondere werden keine Matrizen und auch nicht
% mehrere Parameter von funct verarbeitet!
% 
% Eingangsdaten:	  anz        Zahl der gewnschten bootstrap-Werte von
%                                bsStat
%
%                     funct      Funktionshandle auf eine Funktion, die
%                                den gewnschten statistischen Parameter
%                                bsStat aus den Daten data mit Hilfe der
%                                bootstrap-Technik berechnet.
%                     data       Datenvektor; Stichprobe aus einer
%                                Grundgesamtheit.
%
% Ausgangsdaten:	  bsStat     bootstrap-Werte des untersuchten statistischen
%                                Parameters
%
% Es werden i.W. keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.01
% Datum: 3.9.2004/12.9.2004

inargs = nargin;
outargs = nargout;

if outargs > 1
    warning('bootstrpB hat genbau 1 Ausgangsargument. Die brigen Argumente werden ignoriert!');
    for k=2:outargs
        varargout(k) = {[]};
    end
end

if inargs > 3
    warning('bootstrpB hat hchstens 3 Argumente. Die brigen Argumente werden ignoriert!');
end

if sum(size(data)>[1,1])>=2     % x kein Vektor
    error('bootstrpB kann fr data nur vektorielle Argumente verarbeiten. Abbruch!');
end


% bootstrap-Ziehungen durchfhren

data = data(:);       % immer Spaltenvektor
N = length(data);     % mmer alle Elemente der Grundgesamtheit

% anz Ziehungen durchfhren und Funtionswert berechnen

bsStat =[];

for k=1:anz
    % Initialisierung des Zufallsgenerators
    pause(0.01);
    
    % Ziehung von N Elementen
    indx = unidrndB(N,1,N);
    stprob = data(indx);
    
    % Wert von funct berechnen und hinzufgen
    bsStat = [bsStat, feval(funct, stprob)]; 
end;

