function [p] = chi2cdfB(x,n)
%
% Funktion chi2cdfB
%
% Aufruf: [p] = chi2cdfB(x,n)
%
% Diese Funktion realisiert die kumulative Chi-Quadrat-Verteilung mit 
% n Freiheitsgraden (vgl. Abschnitt 2.7.2).
% Der Wert wird durch numerische Integration von chi2pdfB im Intervall
% [0,x] bis auf 4 Nachkommastellen genau bestimmt.
%
%
% Eingangsdaten:	  x          Wert, bei dem die kumulative chi^2-Verteilung
%                                berechnet werden soll (muss ein Skalar sein)
%
%                     n          Freiheitsgrad
%
% Ausgangsdaten:	  p          Wahrscheinlichkeit P(X<=x)
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 29.8.2004

if sum(size(x)~=[1,1])~=0     % x kein Skalar
    error('chi2cdfB gestattet keine vektoriellen Argumente. Abbruch!');
end

if n<1
    error('Der Freiheitsgrad muss eine Zahl > 0 sein. Abbruch!');
end

optionen = odeset('RelTol',0.00001);


if x<0
    p = 0;
else
    if n == 1   % chi2pdf hat bei 0 eine Singularitt
        [t,y] = ode45(@zuintfdgl,[0.000000001,x],0,optionen,@chi2pdfB,n); 
        p = y(end);
    else
        [t,y] = ode45(@zuintfdgl,[0,x],0,optionen,@chi2pdfB,n); 
        p = y(end);
    end
end




