function [arg] = chi2invB(p,n)
%
% Funktion chi2invB
%
% Aufruf: [arg] = chi2invB(p,n)
%
% Diese Funktion realisiert die INVERSE kumulative chi^2-Verteilung 
% mit n Freiheitsgraden (Chi-Quadrat-Quantile)
% (vgl. Abschnitt 2.7.2)
% Der Wert wird numerisch mit Hilfe der Funktion fzero ermittelt.
% Er kann daher in den Nachkommastellen vom Wert der TOOLBOX-Funktion
% chi2inv abweichen.
%
%
% Eingangsdaten:	  p          Wahrscheinlichkeit, fr die das einseitige
%                                Quantil arg mit P(X<=arg)=p gesucht werden soll
%
%                     n          Freiheitsgrad
%
% Ausgangsdaten:	  arg        Argument
%
% Es werden keine Fehleingaben abgefangen! 
%                                  
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 31.8.2004


if sum(size(p)~=[1,1])~=0     % p kein Skalar
    error('chi2invB gestattet keine vektoriellen Argumente. Abbruch!');
end

optionen = optimset('DiffMaxChange',0.1);

% Bestimmung des Quantils

x0 = 1;                   % Startwert

arg = fzero(@chi2cdfBns,x0,optionen,p,n);







%------------------------------------------------------------
%
% Subfunction fr quivalentes Nullstellenproblem
%

function [y] = chi2cdfBns(x,p,n)
y = chi2cdfB(x,n)-p;