function [zZahl] = chi2rndB(FG,N,M)
%
% Funktion chi2rndB
%
% Aufruf: [zZahl] = chi2rndB(FG,N,M)
%
% Diese Funktion erzeugt Zufallszahlen. Die erzeugten Zufalls-
% zahlen gengen einer Ch-Quadrat-Verteilung mit 
% FG Freiheitsgraden.
%
%
% Eingangsdaten:	  FG         Freiheitsgrade (>1)
%                     
%                     N,M        Dimension der Zufallszahlenmatrix
%
% Ausgangsdaten:	  zZahl      erzeugte Zufallszahl
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.01
% Datum: 31.8.2004/13.9.2004


nargs = nargin;

if nargs == 1            % Default: eine Zahl
    N = 1; M = 1;
elseif  nargs>3
    error('Aufrufkonvention von chi2rndB beachten. Abbruch!');  
end

if FG<1 | abs(FG-floor(FG))>eps  
    error('Der Parameter FG muss eine ganze Zahl > 1 sein. Abbruch!');  
end

                                 % (Gleichverteilten) Zufallspunkt im Intervall 
                                 % [0,1] bestimmen
x = rand(N,M);
for k=1:N
    for m=1:M
                                 % Transformationsformel anwenden
        zZahl(k,m) = chi2invB(x(k,m),FG);
    end
end
 
