function [wD] = exppdfB(x,T)
%
% Funktion exppdfB
%
% Aufruf: [wD] = exppdfB(x,T)
%
% Diese Funktion realisiert die Dichte der Exponentialverteilung mit 
% (Zeit-)Parameter T (vgl. Abschnitt 2.5.5)
%
%
% Eingangsdaten:	  x          Wert, bei dem die Dichte der Exponentialverteilung
%                                berechnet werden soll
%
%                     T          Zeitparameter T = 1/lambda
%
% Ausgangsdaten:	  wD         Wert der Dichte bei x
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 31.8.2004


if T<=eps
    error('Der Zeitparameter T muss eine Zahl > 0 sein. Abbruch!');
end

wD = (x>=0).*(1/T).*exp(-x/T);

