function [arg] = finvB(p,m,n)
%
% Funktion finvB
%
% Aufruf: [arg] = finvB(p,m,n)
%
% Diese Funktion realisiert die INVERSE kumulative F-Verteilung 
% mit m,n Freiheitsgraden (F-Quantile)
% (vgl. Abschnitt 2.7.2)
% Der Wert wird numerisch mit Hilfe der Funktion fzero ermittelt.
% Er kann daher in den Nachkommastellen vom Wert der TOOLBOX-Funktion
% finv abweichen.
%
%
% Eingangsdaten:	  p          Wahrscheinlichkeit, fr die das einseitige
%                                Quantil arg mit P(X<=arg)=p gesucht werden soll
%
%                     m          1. Freiheitsgrad
%                     n          2. Freiheitsgrad
%
% Ausgangsdaten:	  arg        Argument
%
% Es werden keine Fehleingaben abgefangen! 
%                                  
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 30.8.2004


if sum(size(p)~=[1,1])~=0     % p kein Skalar
    error('finvB gestattet keine vektoriellen Argumente. Abbruch!');
end

optionen = optimset('DiffMaxChange',0.1);

% Bestimmung des Quantils

x0 = 1;                   % Startwert

arg = fzero(@fcdfBns,x0,optionen,p,m,n);







%------------------------------------------------------------
%
% Subfunction fr quivalentes Nullstellenproblem
%

function [y] = fcdfBns(x,p,m,n)
y = fcdfB(x,m,n)-p;