function [wD] = fpdfB(x,m,n)
%
% Funktion fpdfB
%
% Aufruf: [wD] = fpdfB(x,m,n)
%
% Diese Funktion realisiert die Dichte der F-Verteilung mit m,n Freiheitsgraden
% (vgl. Abschnitt 2.7.2)
%
%
% Eingangsdaten:	  x          Wert, bei dem die Dichte der F-Verteilung
%                                berechnet werden soll
%
%                     m          1. Freiheitsgrad
%                     n          2. Freiheitsgrad
%
% Ausgangsdaten:	  wD         Wert der Dichte bei x
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 29.8.2004


faktor1 = gamma((m+n)/2)/(gamma(m/2)*gamma(n/2));
faktor2 = m^(m/2)*n^(n/2);
wD = (x>=0).*faktor1.*faktor2.*x.^((m-2)/2)./(m*x+n).^((m+n)/2);



