function [mw,var] = fstatB(m,n)
%
% Funktion fstatB
%
% Aufruf: [mw,var] = fstatB(m,n)
%
% Diese Funktion bestimmt Mittelwert und Varianz der F-Verteilung 
% mit m,n Freiheitsgraden.
%
%
% Eingangsdaten:	  m          1. Freiheitsgrad
%                     n          2. Freiheitsgrad
%
% Ausgangsdaten:	  mw         Erwartungswert
%                     var        Varianz
%
% Es werden keine Fehleingaben abgefangen! 
%                                  
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 30.8.2004


if sum(size(m)~=[1,1])~=0 | sum(size(n)~=[1,1])~=0    % kein Skalar
    error('fstatB gestattet keine vektoriellen Argumente. Abbruch!');
end

if m<=0 | n<=0
    error('Freiheitsgrade mssen positiv sein. Abbruch!');
end 

if n<=2 
    mw = NaN; var = NaN;
elseif n<=4
    mw = n/(n-2);
    var = NaN;
else
    mw = n/(n-2);
    var = (mw^2)*2.0*(m+n-2)/(m*(n-4));
end
