function [Fval] = hygecdfB(x,m,k,n)
%
% Funktion hygecdfB
%
% Aufruf: [Fval] = hygecdfB(x,m,k,n)
%
% Diese Funktion berechnet die kumulative hypergeometrische Verteilung mit 
% den Parametern und p.
% (vgl. Abschnitt 2.2.1)
% 
% Eingangsdaten:	  x          GANZZAHLIGE Werte, bei denen die Verteilung
%                                berechnet werden soll (muss ein Skalar oder
%                                ein Zeilen- oder Spaltenvektor sein)
%
%                     m          Anzahlparameter
%                     k          Anzahlparameter
%                     n          Anzahlparameter
%
% Ausgangsdaten:	  Fval       Wahrscheinlichkeit(en) P(X<=x)
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 29.8.2004/12.9.2004

if sum(size(x)>1)>1 % x kein Skalar oder Vektor
    error('hygecdfB gestattet nur skalare oder vektorielle Argumente. Abbruch!');
end

N = length(x);
Fval = NaN*ones(size(x));

for s = 1:N
    j = floor(x(s));           % nchstkleinerer ganzzahliger Wert

    if j<0
        Fval(s) = 0;
    else
        Fval(s) = 0;           % Vorinitialisierung
        for r=0:j              % Werte der Binomialverteilung akkumulieren.
            Fval(s) = Fval(s) + hygepdfB(r,m,k,n);
        end
    end

    if Fval(s)>1
        Fval(s)=1;
    end
end


