function [Fval] = hygepdfB(x,m,k,n)
%
% Funktion hygepdfB
%
% Aufruf: [Fval] = hygepdfB(x,m,k,n)
%
% Diese Funktion berechnet die hypergeometrische Verteilung mit 
% den Parametern und m,k und n.
% (vgl. Abschnitt 2.2.1)
% 
% Eingangsdaten:	  x          GANZZAHLIGE Werte, bei denen die Verteilung
%                                berechnet werden soll (muss ein Skalar oder
%                                ein Zeilen- oder Spaltenvektor sein)
%
%                     m          Anzahlparameter
%                     k          Anzahlparameter
%                     n          Anzahlparameter
%
% Ausgangsdaten:	  Fval       Wahrscheinlichkeit(en) P(X=x)
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 29.8.2004/12.9.2004

warning off         % fr Warnmeldungen von nchooosek

if sum(size(x)>1)>1 % x kein Skalar oder Vektor
    error('hygepdfB gestattet nur skalare oder vektorielle Argumente. Abbruch!');
end

N = length(x);
Fval = NaN*ones(size(x));

for s = 1:N
    j = floor(x(s));       % nchstkleinerer ganzzahliger Wert
    if abs(x(s)-j)>eps     % kein ganzzahliger Wert
        Fval(s) = 0;
    elseif j < 0
        Fval(s) = 0;
    elseif j<=n
        Fval(s) = nchoosek(k,j)*nchoosek(m-k,n-j)/nchoosek(m,n);
    else
        Fval(s) = 0;
    end
end
   


