function [p] = kolmcdfB(lambda)
%
% Funktion kolmcdfB
%
% Aufruf: [p] = kolmcdfB(lambda)
%
% Diese Funktion realisiert (approximativ) die kumulative Q-Verteilung nach
% Kolmogorov-Smirnov.
%
%
% Eingangsdaten:	  lambda     Wert, bei dem die kumulative Q-Verteilung
%                                berechnet werden soll
%
% Ausgangsdaten:	  p          P(X<=lambda)
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 14.9.2004

if sum(size(lambda)>[1,1])>1 % x kein Skalar oder Vektor
    error('kolmcdfB gestattet nur skalare oder vektorielle Argumente. Abbruch!');
end

% P-Werte Vorinitialisieren
p = zeros(size(lambda));

% Reihenentwicklung approximieren

for k=1:100
   Summand = (-1)^k*(lambda>0).*exp(-2*k^2*lambda.^2);
   p = p + 2*Summand;
end

p = p + 1;       % Fr Summand mit k=0
p(lambda<=0) = 0;

