function [arg] = kolminvB(p)
%
% Funktion kolminvB
%
% Aufruf: [arg] = kolminvB(p)
%
% Diese Funktion realisiert die INVERSE kumulative Q-Verteilung nach
% Kolmogorov-Smirnov.
% 
% Der Wert wird numerisch mit Hilfe der Funktion fzero ermittelt.
% Er kann daher in den Nachkommastellen vom Wert der (undokumentierten)
% TOOLBOX-Funktion kolminv abweichen.
%
%
% Eingangsdaten:	  p          Wahrscheinlichkeit, fr die das einseitige
%                                Quantil arg mit P(X<=arg)=p gesucht werden soll
%
% Ausgangsdaten:	  arg        Argument
%
% Es werden keine Fehleingaben abgefangen! 
%                                  
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 14.9.2004


if sum(size(p)~=[1,1])~=0     % p kein Skalar
    error('kolminvB gestattet keine vektoriellen Argumente. Abbruch!');
end

optionen = optimset('DiffMaxChange',0.1);

% Bestimmung des Quantils

x0 = 1;                   % Startwert

arg = fzero(@kolmcdfBns,x0,optionen,p);







%------------------------------------------------------------
%
% Subfunction fr quivalentes Nullstellenproblem
%

function [y] = kolmcdfBns(x,p)
y = kolmcdfB(x)-p;