function [wD] = lognpdfB(x,mu,sigma)
%
% Funktion lognpdfB
%
% Aufruf: [wD] = lognpdfB(x,mu,sigma)
%
% Diese Funktion realisiert die Dichte der logarithmischen Normalverteilung mit 
% dem Parametern mu und sigma (vgl. Abschnitt 2.7.2)
%
%
% Eingangsdaten:	  x          Wert, bei dem die Dichte der chi^2-Verteilung
%                                berechnet werden soll
%
%                     mu         1. Parameter
%                     sigma      2. Parameter
%
% Ausgangsdaten:	  wD         Wert der Dichte bei x
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 31.8.2004

if sigma<=eps
    error('Der Parameter sigma muss eine Zahl > 0 sein. Abbruch!');
end

faktor2 = -1/(2*sigma^2);
faktor1 = 1./((x+eps)*sigma*sqrt(2*pi));
wD = faktor1.*exp(faktor2.*(log(x+eps)-mu).^2);




