function [mw,var] = lognstatB(mu,sigma)
%
% Funktion lognstatB
%
% Aufruf: [mw,var] = lognstatB(mu,sigma)
%
% Diese Funktion bestimmt Mittelwert und Varianz logarithmischen 
% Normalverteilung mit dem Parametern mu und sigma (vgl. Abschnitt 2.7.2)
%
%
% Eingangsdaten:	  mu         1. Parameter
%                     sigma      2. Parameter
%
% Ausgangsdaten:	  mw         Erwartungswert
%                     var        Varianz
%
% Es werden keine Fehleingaben abgefangen! 
%                                  
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 31.8.2004


if sum(size(mu)~=[1,1])~=0 | sum(size(sigma)~=[1,1])~=0    % kein Skalar
    error('lognstatB gestattet keine vektoriellen Argumente. Abbruch!');
end

if sigma<=eps
    error('Der Parameter sigma muss eine Zahl > 0 sein. Abbruch!');
end

mw = exp(mu+sigma^2/2); 
var = exp(2*mu+sigma^2)*(exp(sigma^2)-1); ;