function [Fval] = nbincdfB(x,k,p)
%
% Funktion nbincdfB
%
% Aufruf: [Fval] = nbincdfB(x,k,p)
%
% Diese Funktion berechnet die kumulative negative Binomialverteilung 
% (PASCAL-Verteilung) mit den Parametern k und p.
% (vgl. Abschnitt 2.2.1)
% 
% Eingangsdaten:	  x          Werte, bei denen die kumulative Verteilung
%                                berechnet werden soll (muss ein Skalar oder
%                                ein Zeilen- oder Spaltenvektor sein)
%
%                     k          Anzahlparameter
%                     p          Wahrscheinlichkeitsparameter
%
% Ausgangsdaten:	  Fval       Wahrscheinlichkeit P(X<=x)
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.01
% Datum: 31.8.2004/14.9.2004


if sum(size(x)>1)>1 % x kein Skalar oder Vektor
    error('binopdfB gestattet nur skalare oder vektorielle Argumente. Abbruch!');
end

N = length(x);
Fval = NaN*ones(size(x));

for s = 1:N
    m = floor(x(s));       % nchstkleinerer ganzzahliger Wert

    if m<0
        Fval(s) = 0;
    else
        Fval(s) = 0;       % Vorinitialisierung
        for j=0:m             % Werte der negativen Binomialverteilung akkumulieren.
            Fval(s) = Fval(s) + nbinpdfB(j,k,p);
        end
    end

    if Fval(s)>1
        Fval(s)=1;
    end
end


