function [p] = normcdfB(x,mu,sigma)
%
% Funktion normcdfB
%
% Aufruf: [p] = normcdfB(x,mu,sigma)
%
% Diese Funktion realisiert die Verteilungsfunktion der Normalverteilung mit 
% dem Parametern mu und sigma (vgl. Abschnitt 2.7.2)
%
% Der Wert wird mit Hilfe der Standard-MATLAB-Funktion erf(x)
% (Errorfunction) berechnet.
%
%
% Eingangsdaten:	  x          Wert, bei dem die Dichte Normalverteilung
%                                berechnet werden soll
%
%                     mu         1. Parameter (Mittelwert)
%                     sigma      2. Parameter (Streuung)
%
% Ausgangsdaten:	  p          Wert der Verteilungsfunktion P(X<=x)
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 31.8.2004

nargs = nargin;

if nargs == 1            % Default: Standard-Normalverteilung
    mu = 0; sigma = 1;
end

if sigma<=eps
    error('Der Parameter sigma muss eine Zahl > 0 sein. Abbruch!');
end

if  x-mu>0
    p = 0.5 + 0.5*erf( (x-mu)/(sigma*sqrt(2)) );
else
    p = 0.5 - 0.5*erf( (mu-x)/(sigma*sqrt(2)) );
end



