function [arg] = norminvB(p,mu,sigma)
%
% Funktion norminvB
%
% Aufruf: [arg] = norminvB(p,mu,sigma)
%
% Diese Funktion realisiert die inverse Verteilungsfunktion der Normalverteilung mit 
% dem Parametern mu und sigma (Quantile der Normalverteilung)
%
% Der Wert wird mit Hilfe der Standard-MATLAB-Funktion erfinv(x)
% (inverse Errorfunction) berechnet.
%
%
% Eingangsdaten:	  p          Wahrscheinlichkeit
%
%                     mu         1. Parameter (Mittelwert)
%                     sigma      2. Parameter (Streuung)
%
% Ausgangsdaten:	  arg        Quantil der Normalverteilung zu p
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 31.8.2004

nargs = nargin;

if nargs == 1            % Default: Standard-Normalverteilung
    mu = 0; sigma = 1;
end

if sigma<=eps
    error('Der Parameter sigma muss eine Zahl > 0 sein. Abbruch!');
end

if p<0 | p>1
    error('Der Parameter p muss im Intervall [0,1] liegen. Abbruch!');
end

if  p>=1/2
    arg = sigma*sqrt(2)*erfinv( 2*p-1 )+mu;
else
    arg = -sigma*sqrt(2)*erfinv( 1-2*p )+mu;
end




