function [wD] = normpdfB(x,mu,sigma)
%
% Funktion normpdfB
%
% Aufruf: [wD] = normpdfB(x,mu,sigma)
%
% Diese Funktion realisiert die Dichte der Normalverteilung mit 
% dem Parametern mu und sigma (vgl. Abschnitt 2.7.2)
%
%
% Eingangsdaten:	  x          Wert, bei dem die Dichte Normalverteilung
%                                berechnet werden soll
%
%                     mu         1. Parameter (Mittelwert)
%                     sigma      2. Parameter (Streuung)
%
% Ausgangsdaten:	  wD         Wert der Dichte bei x
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 31.8.2004

nargs = nargin;

if nargs == 1            % Default: Standard-Normalverteilung
    mu = 0; sigma = 1;
end

if sigma<=eps
    error('Der Parameter sigma muss eine Zahl > 0 sein. Abbruch!');
end

faktor1 = 1/(sigma*sqrt(2*pi));
faktor2 = -1/(2*sigma^2);

wD = faktor1.*exp(faktor2*(x-mu).^2);




