function [p,h] = normspecB(intv,mu,sigma)
%
% Funktion normspecB
%
% Aufruf: [p,h] = normspecB(intv,mu,sigma)
%
% Diese Funktion plottes die Normalverteilung zwischen der im Intervall
% intv angegebenen untern und oberen Grenze. 
% p ist die Wahrscheinlichkeit, mit der ein Wert in das Intervall intv
% fllt, h ist ein leerer Vektor, der aus Kompatibilittsgrnden mit
% der Toolbox-Funktion normspec in der Liste der Rckgabeparameter erscheint.
%
% Eingangsdaten:	  intv       ein Intervall [a,b]; a und b drfen die Werte
%                                -Inf und Inf annehmen
%                     mu         1. Parameter (Mittelwert)
%                     sigma      2. Parameter (Streuung)
%
% Ausgangsdaten:	  p          P(a<=X<=b)
%                     h          immer gleich []
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 31.8.2004


nargs = nargin;

if nargs == 1            % Default: Standard-Normalverteilung
    mu = 0; sigma = 1;
end

if sigma<=eps
    error('Der Parameter sigma muss eine Zahl > 0 sein. Abbruch!');
end

if size(intv)~=[1,2] | intv(2)<intv(1)
    error('Der Parameter intv muss ein reelles Intervall sein. Abbruch!');
end


p = normcdfB(intv(2),mu,sigma)-normcdfB(intv(1),mu,sigma);
h = [];

% Plotgrenzen bestimmen

if intv(1) ~= -Inf
    links = min(intv(1),mu-4*sigma);
    a = intv(1);
else
    links = mu-4*sigma;
    a = links;
end

if intv(2) ~= Inf
    rechts = max(intv(2),mu+4*sigma);
    b = intv(2);
else
    rechts = mu+4*sigma;
    b = rechts;
end

dx = (rechts-links)/100;
x = (links:dx:rechts);
y = normpdfB(x,mu,sigma);

% Dichte plotten

plot(x, y, 'b-', 'LineWidth', 3);
xlabel('Kritische Werte');
ylabel('Dichte');
title(['Wahrscheinlichkeit in den Grenzen ',num2str(p)]);
axis([links,rechts,0,1.03*max(y)])

% Flche ausfllen

x1 = (a:dx:b);
y1 = normpdfB(x1,mu,sigma);
x1 = [a, x1, b]; 
y1 = [0, y1, 0];
patch(x1,y1,'y');

