function [Fval] = poisscdfB(x,mu)
%
% Funktion poisscdfB
%
% Aufruf: [Fval] = poisscdfB(x,mu)
%
% Diese Funktion berechnet die kumulative Poisson-Verteilung mit 
% Parameter mu.
% (vgl. Abschnitt 2.7.1)
% 
% Eingangsdaten:	  x          GANZZAHLIGE Werte, bei denen die Verteilung
%                                berechnet werden soll (muss ein Skalar oder
%                                ein Zeilen- oder Spaltenvektor sein)
%
%                     mu         Parameter der Poisson-Verteilung (Mittelwert)
%
% Ausgangsdaten:	  Fval       Wahrscheinlichkeit P(X<=x)
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.01
% Datum: 1.9.2004/12.9.2004


if sum(size(x)>1)>1 % x kein Skalar oder Vektor
    error('binopdfB gestattet nur skalare oder vektorielle Argumente. Abbruch!');
end

N = length(x);
Fval = NaN*ones(size(x));

for j = 1:N
    m = floor(x(j));       % nchstkleinerer ganzzahliger Wert

    if m<0
        Fval(j) = 0;
    else
        Fval(j) = 0;       % Vorinitialisierung
        for k=0:m          % Werte der Poisson-Verteilung akkumulieren.
        Fval(j) = Fval(j) + poisspdfB(k,mu);
    end
    end

    if Fval(j)>1
        Fval(j)=1;
    end
end

