function [Qval] = poissinvB(p,mu)
%
% Funktion poissinvB
%
% Aufruf: [Qval] = poissinvB(p,mu)
%
% Diese Funktion berechnet die Quantile der Poisson-Verteilung mit 
% Parameter mu.
% (vgl. Abschnitt 2.7.1)
% 
% Eingangsdaten:	  p          vorgegebene Wahrscheinlichkeit
%
%                     mu         Parameter der Poisson-Verteilung (Mittelwert)
%
% Ausgangsdaten:	  Qval       GANZZAHLIGER Wert mit P(X <= Qval) = p
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 14.9.2004


if sum(size(p)>1)~=0 | sum(size(mu)>1)~=0% kein Skalar
    error('poissinvB gestattet nur skalare Argumente. Abbruch!');
end

Qval = 0;

while poisscdfB(Qval,mu)<p
    Qval = Qval+1;
end