function [Fval] = poisspdfB(x,mu)
%
% Funktion poisspdfB
%
% Aufruf: [Fval] = poisspdfB(x,mu)
%
% Diese Funktion berechnet die Poisson-Verteilung mit 
% Parameter mu.
% (vgl. Abschnitt 2.7.1)
% 
% Eingangsdaten:	  x          GANZZAHLIGE Werte, bei denen die Verteilung
%                                berechnet werden soll (muss ein Skalar oder
%                                ein Zeilen- oder Spaltenvektor sein)
%
%                     mu         Parameter der Poisson-Verteilung (Mittelwert)
%
% Ausgangsdaten:	  Fval       Wahrscheinlichkeit(en) P(X=x)
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 12.01
% Datum: 1.9.2004/12.9.2004

if sum(size(x)>1)>1 % x kein Skalar oder Vektor
    error('binopdfB gestattet nur skalare oder vektorielle Argumente. Abbruch!');
end

N = length(x);
Fval = NaN*ones(size(x));

for j = 1:N
    k = floor(x(j));       % nchstkleinerer ganzzahliger Wert
    if abs(x(j)-k)>eps     % kein ganzzahliger Wert
        Fval(j) = 0;
    elseif k < 0
        Fval(j) = 0;
    else
        Fval(j) = mu^k*exp(-mu)/factorial(k);
    end
end  


