function [beta,VIbeta,residuen,VIResiduen,StatRFp] = regressB(yWerte,X)
%
% Funktion regressB
%
% Aufruf: [beta,VIbeta,residuen,VIResiduen,StatRFp] = regressB(yWerte,X)
%
% Diese Funktion fhrt fr die Daten in yWerte und X eine (multiple)
% lineare Regression der Form y = f(X) = X*beta durch 
% (vgl. Abschnitt 5.6.1 und 5.6.2 sowie die Programme RegressVInt.m
% und BspMultipRegress.m der Begleitsoftware).
%
% Die Funktion hat gegenber der Statistics-Toolbox-Funktion regress
% EINGESCHRNKTE FUNKTIONALITT. Die Parameter VIbeta,residuen,
% VIResiduen,StatRFp werden NICHT berechnet. Es werden lediglich leere
% Vektoren zurckgeliefert, um die Kompatibilitt zu den Schnittstellen
% von regress zu erhalten.
%
%
% Eingangsdaten:	  yWerte     (nx1)-Vektor der Beobachtungen
%
%                     X          (nxr)-Matrix der unabhngigen Variablen
%
%
% Ausgangsdaten:	  beta       (rx1)-Vektor der Koeffizienten
%
%                     VIbeta     = []
%
%                     residuen   = []
%
%                     VIResiduen = []
%
%                     StatRFp    = []
%
% Es werden i.W. keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 5.9.2004

nargs = nargin;

if  nargs ~= 2 
    error('Aufrufstruktur von regressB beachten. Abbruch!');
end

if sum(size(yWerte)>[1,1])>=2   % yWerte kein Vektor
    error('Erster Parameter von regressB muss ein Vektor sein. Abbruch!');
end

yWerte = yWerte(:);
[ny,ry] = size(yWerte);
[nX,rX] = size(X);

if ny ~=nX                      % Dimensionen stimmen nicht
    error('X muss soviele Zeilen haben, wie yWerte Elemente hat. Abbruch!');
end

% Vorinitialisierungen

VIbeta = []; residuen = []; VIResiduen = []; StatRFp = [];

% Berechnung der Regressionskoeffizienten

beta = inv(X'*X)*X'*yWerte;



