function [p] = tcdfB(x,n)
%
% Funktion tcdfB
%
% Aufruf: [p] = tcdfB(x,n)
%
% Diese Funktion realisiert die kumulative t-Verteilung mit 
% n Freiheitsgraden (vgl. Abschnitt 2.7.2).
% Der Wert wird durch numerische Integration von tpdfB im Intervall
% [0,x] bis auf 4 Nachkommastellen genau bestimmt.
%
%
% Eingangsdaten:	  x          Wert, bei dem die kumulative chi^2-Verteilung
%                                berechnet werden soll (muss ein Skalar sein)
%
%                     n          Freiheitsgrad
%
% Ausgangsdaten:	  p          Wahrscheinlichkeit P(X<=x)
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 1.9.2004

if sum(size(x)~=[1,1])~=0     % x kein Skalar
    error('chi2cdfB gestattet keine vektoriellen Argumente. Abbruch!');
end

if n<1
    error('Der Freiheitsgrad muss eine Zahl > 0 sein. Abbruch!');
end

optionen = odeset('RelTol',0.00001);


if x<0
    [t,y] = ode45(@zuintfdgl,[0,-x],0,optionen,@tpdf,n); 
    p = 1/2-y(end);
else
    [t,y] = ode45(@zuintfdgl,[0,x],0,optionen,@tpdf,n); 
    p = 1/2+y(end);
end




