function [wD] = tpdfB(x,n)
%
% Funktion tpdfB
%
% Aufruf: [wD] = tpdfB(x,n)
%
% Diese Funktion realisiert die Dichte der t-Verteilung mit 
% n Freiheitsgraden (vgl. Abschnitt 2.7.2)
%
%
% Eingangsdaten:	  x          Wert, bei dem die Dichte der t-Verteilung
%                                berechnet werden soll
%
%                     n          Freiheitsgrad
%
% Ausgangsdaten:	  wD         Wert der Dichte bei x
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 1.9.2004


if n<1
    error('Der Freiheitsgrad muss eine Zahl > 0 sein. Abbruch!');
end

faktor = gamma((n+1)/2)/(sqrt(n*pi)*gamma(n/2));
wD = faktor./(1+(x.^2)/n).^((n+1)/2);



