function [mw,var] = tstatB(n)
%
% Funktion tstatB
%
% Aufruf: [mw,var] = tstatB(n)
%
% Diese Funktion bestimmt Mittelwert und Varianz der t-Verteilung 
% mit n Freiheitsgraden.
%
%
% Eingangsdaten:	  n          Freiheitsgrad
%
% Ausgangsdaten:	  mw         Erwartungswert
%                     var        Varianz
%
% Es werden keine Fehleingaben abgefangen! 
%                                  
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 1.9.2004


if sum(size(n)~=[1,1])~=0    % kein Skalar
    error('tstatB gestattet keine vektoriellen Argumente. Abbruch!');
end

if n<=0
    error('Der Freiheitsgrad muss positiv sein. Abbruch!');
end 

mw = 0; 

if n<=2
    var = NaN;
else
    var = n/(n-2);
end 
