function [TEnt,pWert,KonfInt,Entscheidung] = ttestB(daten,mu,alpha,altHyp)
%
% Funktion ttestB
%
% Aufruf: [TEnt,pWert,KonfInt,Entscheidung] = ttestB(daten,mu,alpha,altHyp)
%
% Diese Funktion fhrt fr die Daten im Vektor daten einen t-Test 
% (Test des Mittelwerts einer Normalverteilung bei bekannter Varianz) durch!
% (vgl. Abschnitt 5.4.2)
%
%
% Eingangsdaten:	  daten      Stichprobe (Vektor von Werten)
%
%                     mu         Parameter der Normalverteilung
%                                default ist mu=0 
%
%                     alpha      Signifikanzniveau (0<=alpha<=1)
%                                default ist 0.05
%
%                     altHyp     Art des Tests (0 = zweiseitig,
%                                1 = einseitig grer, -1 = einseitig kleiner)
%                                default ist 0
%
% Ausgangsdaten:	  TEnt       Testergebnis
%
%                     pWert      p-Wert
%
%                     KonfInt    Konfidenzintervall
%
%                     Entscheidung      
%                                Struktur mit dem Testergebnis
%
% Es werden i.W. keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.01
% Datum: 5.9.2004/14.9.2004

nargs = nargin;

if sum(size(daten)>[1,1])>=2   % daten kein Vektor
    error('ttestB kann fr daten nur vektorielle Argumente verarbeiten. Abbruch!');
end


if nargs == 1            % Defaultfall 1
    mu = 0; alpha = 0.05; altHyp = 0;
elseif nargs == 2        % Defaultfall 2
    alpha = 0.05; altHyp = 0;
elseif nargs == 3        % Defaultfall 3
    altHyp = 0;
elseif nargs<1 | nargs>4
    error('Aufrufstruktur von ttestB beachten. Abbruch!');
else
    % tue nichts
end

% Vorinitialisierungen

n = length(daten);
sigma = std(daten);
Entscheidung.Testniveau = alpha;
if altHyp<-eps
    Entscheidung.Testart = 't-Test einseitig nach unten';
elseif altHyp >eps
    Entscheidung.Testart = 't-Test einseitig nach oben';
else
    Entscheidung.Testart = 't-Test zweiseitig';
end

Entscheidung.Vertrauensintervall = [];

% Wert der Testvariablen T
Entscheidung.Testvariable_T = sqrt(n)*(mean(daten)-mu)/sigma;
Entscheidung.Freiheitsgrade_T = n-1;
% p-Wert
Entscheidung.pWert = [];

Entscheidung.Testentscheidung = [];

% Berechnung des Vertrauensintervalls

if altHyp>eps        % einseitig nach oben
    quantil = tinvB(1-alpha,n-1);
    Entscheidung.Vertrauensintervall = ...
        [mean(daten)-quantil*sigma/sqrt(n), Inf];
    Entscheidung.pWert = 1-tcdfB(Entscheidung.Testvariable_T,n-1);
elseif altHyp <-eps   % einseitig nach unten
    quantil = tinvB(1-alpha,n-1);
    Entscheidung.Vertrauensintervall = ...
        [-Inf, mean(daten)+quantil*sigma/sqrt(n)];
    Entscheidung.pWert = tcdfB(Entscheidung.Testvariable_T,n-1);
else                 % zweiseitiger Test
    quantil = tinvB(1-alpha/2,n-1);
    Entscheidung.Vertrauensintervall = ...
        [mean(daten)-quantil*sigma/sqrt(n), mean(daten)+quantil*sigma/sqrt(n)];
    Entscheidung.pWert = min(2*tcdfB(Entscheidung.Testvariable_T,n-1),...
                               2*(1-tcdfB(Entscheidung.Testvariable_T,n-1)));
end

pWert= Entscheidung.pWert;
KonfInt = Entscheidung.Vertrauensintervall;
TEnt = Entscheidung.pWert < alpha; 

if TEnt
     Entscheidung.Testentscheidung = 'Die Nullhypothese wird abgelehnt!';
else
     Entscheidung.Testentscheidung = 'Die Nullhypothese wird nicht abgelehnt!';
end