function [zZahlen] = unidrndB(K,N,M)
%
% Funktion unidrndB
%
% Aufruf: [zZahlen] = unidrndB(K,N,M)
%         [zZahl] = unidrndB(K)
%
% Diese Funktion erzeugt im der Menge {1,2,3,..,K} gleichverteilte
% Zufallszahlen.
%
%
% Eingangsdaten:	  K          GANZE Zahl > 0
%                     N,M        Matrixgre
%
% Ausgangsdaten:	  [zZahlen]  erzeugte Zufallszahlen
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 1.9.2004

narg = nargin;

if K<1 | abs(K-floor(K))>eps
    error('Der Parameter K muss >=1 und ganzzahlig sein. Abbruch!');
end

if narg == 1
    N = 1; M = 1;
end

% Vorinitialisierung;
zZahlen = [];
pause(0.001*rand(1,1));          % Zufallsgenerator initialisieren
rand('state',sum(100*clock));   
                                 % (Gleichverteilte) Zufallspunkte im Intervall 
                                 % [0,1] bestimmen
x = rand(N,M);
                                 % Transformationsformel anwenden
zZahlen = round(0.5 + K*x);
 
