function [p] = unifcdfB(x,a,b)
%
% Funktion unifcdfB
%
% Aufruf: [p] = unifcdfB(x,a,b)
%
% Diese Funktion realisiert die kumulative Gleichverteilung im
% Intervall [a,b].
% (vgl. Abschnitt 2.3.2)
%
%
% Eingangsdaten:	  x          Wert, bei dem die kumulative
%                                Gleichverteilung berechnet werden soll
%
%                     a          linke Intervallgrenze
%                     b          rechte Intervallgrenze
%
% Ausgangsdaten:	  p          Wert P(X<=x)
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 1.9.2004


if b<=a
    error('Die linke Intervallgrenze muss kleiner als die rechte sein. Abbruch!');
end

faktor = 1/(b-a);
p = faktor*(x>=a).*(x<=b).*(x-a)+(x>b);
