function [zZahlen] = unifrndB(a,b,N,M)
%
% Funktion unifrndB
%
% Aufruf: [zZahlen] = unifrndB(a,b,N,M)
%         [zZahl] = unifrndB(a,b)
%
% Diese Funktion erzeugt im Intervall [a,b] gleichverteilte
% Zufallszahlen.
%
%
% Eingangsdaten:	  a          linke Intervallgrenze
%                     b          rechte Intervallgrenze
%                     N,M        Matrixgre
%
% Ausgangsdaten:	  [zZahlen]  erzeugte Zufallszahlen
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 1.9.2004

narg = nargin;

if b<=a
    error('Die linke Intervallgrenze muss kleiner als die rechte sein. Abbruch!');
end

if narg == 2
    N = 1; M = 1;
end

% Vorinitialisierung;
zZahlen = [];
   
                                 % (Gleichverteilte) Zufallspunkte im Intervall 
                                 % [0,1] bestimmen
x = rand(N,M);
                                 % Transformationsformel anwenden
zZahlen = a + (b-a)*x;
 
