function [arg] = weibinvB(p,a,b)
%
% Funktion weibinvB
%
% Aufruf: [arg] = weibinvB(p,a,b)
%
% Diese Funktion realisiert die INVERSE kumulative Weibull-Verteilung 
% mit den Parametern a und b (vgl. Abschnitt 2.7.2)
%
%
% Eingangsdaten:	  p          Wahrscheinlichkeit, fr die das einseitige
%                                Quantil arg mit P(X<=arg)=p gesucht werden soll
%
%
%                     a          Zeitparameter; es gilt a = (1/T)^b, d.h. T^b = 1/a
%                                mit dem Zeitparameter T aus Abschnitt 2.7.2
%                     b          Formparameter
%
% Ausgangsdaten:	  arg        Wert mit P(X<=arg)=p
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 1.9.2004


if sum(size(p)~=[1,1])~=0     % p kein Skalar
    error('weibinvB gestattet keine vektoriellen Argumente. Abbruch!');
end

arg = (-log(1-p)/a)^(1/b);