function [mw,var] = weibstatB(a,b)
%
% Funktion weibstatB
%
% Aufruf: [mw,var] = weibstatB(a,b)
%
% Diese Funktion bestimmt Mittelwert und Varianz der Weibull-Verteilung 
% mit den Parametern a und b (vgl. Abschnitt 2.7.2)
%
%
% Eingangsdaten:	  a          Zeitparameter; es gilt a = (1/T)^b, d.h. T^b = 1/a
%                                mit dem Zeitparameter T aus Abschnitt 2.7.2
%                     b          Formparameter
%
% Ausgangsdaten:	  mw         Erwartungswert
%                     var        Varianz
%
% Es werden keine Fehleingaben abgefangen! 
%                                 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 1.9.2004

if a<=eps
    error('Der Zeitparameter a muss eine Zahl > 0 sein. Abbruch!');
end

if b<=eps
    error('Der Formparameter b muss eine Zahl > 0 sein. Abbruch!');
end

mw = (1/a)^(1/b)*gamma(1+1/b);
var = (1/a)^(2/b)*( gamma(1+2/b) - (gamma(1+1/b))^2 );
