function [y] = FBspVertFkt(x)
%
% Funktion FBspVertFkt
%
% Aufruf:  [y] = FBspVertFkt(x)
%
% Aufrufbeispiel:    [y] = FBspVertFkt(x)
%
% Die vorliegende Funktion implementiert das Beispiel einer Verteilungsfunktion
% zu einer bungsaufgabe bezglich der Erzeugung von Zufallszahlen.
%
%
% Eingabeparameter: 		    x           reeller Vektor
%
%
% Ausgabeparameter: 		    y           Wert der Verteilungsfunktion zu x
%                                       
%
% Es werden KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.01
% Datum: 14.08.2004


% Bereiche auswhlen

bu = x<0; bo = x>2;
b1 = (0<=x & x<1); b2 = (1<=x & x<=2);
alpha = 12/5;

y = 0*bu + alpha*b1.*(x.^2/2-x.^3/3) + alpha*b2.*(x/4-1/4) + b2*alpha*(1/6) + bo;