function [params] = FTWeibullComb(daten, paramsH0)
%
% Funktion FTWeibullComb
%
% [params] = FTWeibullComb(daten, paramsH0)
%
% Funktion zur Anpassung der Parameter [p, b1, T1, b2, T2]  
% der VerteilungsFUNKTION einer berlagerung von ZWEI 
% Weibull-Verteilungen (Weibull-Mischverteilung).
%
% Modell:  F(x) = p*fW(b1,T1)+(1-p)*fW(b2,T2)
%
% Eingabeparameter:    daten    Stichprobe der Lnge N
%
%                      paramsH0 Parameter der Nullhypothese
%                               fr [p, b1, T1, b2, T2] 
%
%
% Ausgabeparameter:    params   Schtzwerte der Parameter
%                               [p, b1, T1, b2, T2] 
%
%
% Es werden KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 28.01.2004


% Bestimmung der empirischen Verteilungsfunktion der
% daten mit der NICHT DOKUMENTIERTEN Statistics Toolbox
% Funktion cdfcalc

[ycdf,xcdf] = cdfcalcB(daten);
ycdf = ycdf(2:end);


% Anpassung an das Modell mit Hilfe von nlinfit und 
% der Funktion H0WeibullComb. Die Iteration mit 
% nlinfit wird dabei durch die Parameter der Nullhypothese
% initialisiert

[params,R,J] = nlinfitB(xcdf,ycdf,@H0WeibullComb,paramsH0);

% Anpassung an das Modell mit Hilfe von fmincon und 
% der Funktion H0WeibullComb. Die Iteration mit 
% nlinfit wird dabei durch die Parameter der Nullhypothese
% initialisiert

% lb = zeros(size(paramsH0));
% ub = Inf*ones(size(paramsH0));
% ub(1) = 1;
% options = optimset(@fmincon);
% options = optimset(options, 'LargeScale', 'Off');
% 
% [params] = ...
%     fmincon(@FQminWeibullComb, paramsH0, [], [], [], [],...
%                lb, ub, [], options, xcdf,ycdf);
           
           



