function [T1, T2] = FTWeibullCombT1T2(daten, T1_0, T2_0)
%
% Funktion FTWeibullCombT1T2
%
% [T1, T2] = FTWeibullCombT1T2(daten, T1_0, T2_0)
%
% Funktion zur Anpassung der Parameter [p, b1, T1, b2, T2]  
% der VerteilungsFUNKTION einer berlagerung von ZWEI 
% Weibull-Verteilungen (Weibull-Mischverteilung).
% Dabei sind die Werte p, b1 und b2 auf 1/4, 3/4 und 5 fixiert.
%
% Modell:  F(x) = p*fW(b1,T1)+(1-p)*fW(b2,T2)
%
% Eingabeparameter:    daten       Stichprobe der Lnge N
%
%                      T1_0, T2_0  Parameter der Nullhypothese
%                                  fr [p, b1, T1, b2, T2] 
%
%
% Ausgabeparameter:   T1, T2       Schtzwerte der Parameter
%                                  [p, b1, T1, b2, T2] 
%
%
% Es werden KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 289.01.2004


% Bestimmung der empirischen Verteilungsfunktion der
% Daten mit der NICHT DOKUMENTIERTEN Statistics Toolbox
% Funktion cdfcalc

[ycdf,xcdf] = cdfcalcB(daten);
ycdf = ycdf(2:end);


% Anpassung an das Modell mit Hilfe von nlinfit und 
% der Funktion H0WeibullCombT1T2. Die Iteration mit 
% nlinfit wird dabei durch die Parameter der Nullhypothese
% initialisiert

[params,R,J] = nlinfitB(xcdf,ycdf,@H0WeibullCombT1T2,[T1_0, T2_0]);
T1 = params(1); T2 = params(2);

           



