% Script-File FVertBeispiel.m
%
% Aufruf:  FVertBeispiel
%
% Grafische Darstellung und Kennwerte der F-Verteilung
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 7.03.2003


x=(0:0.001:6);            % Wertebereich von X
n = 6; m = 3;             % Parameter der F-Verteilung
                          % (Zahl der Freiheitsgrade)

                          % Verteilungsdichte der F-Verteilung
pdfF = fpdfB(x, n, m);   
                          % grafische Darstellung
plot(x, pdfF,'r-','LineWidth',4);
set(gca, 'FontSize', 12);
xlabel('Werte von X');
ylabel('Wert der Dichte');
axis([0,6,0,1.1*max(pdfF)])

                          % Berechnung von Erwartungswert und
                          % Varianz
[EW, Var] = fstatB(n, m)
                          % Berechnung des Medianwertes
u_50 = finv(0.5, n, m)                     
                          % Berechnung des Modalwertes
[m,i] = max(pdfF); 
m=x(i)


