% Script-File GaussKQ.m
%
% Aufruf:  GaussKQ
%
% Beispiel fr eine Kleinste-Quadrate-Schtzung mit
% der MATLAB-Funktion nlinfit
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 7.12.2002


mu = 2; sigma = 1;

% 10 Zufallswerte (Stichprobe) einer N(2,1)-Verteilung bestimmen

x = normrndB(mu, sigma, 1, 10);

% Vektor der Indexwerte k

k = (1:1:10);

% Schtzung des Parameters mu mit nlinfit und der Konstantfunktion constMu

anfMu = 0;   % Anfangsschtzung

[MU, R, J] = nlinfitB(k, x, @constMu, anfMu);

% Vergleich von MU, mu und der Schtzung xquer

fprintf('\n%s:   %10.4f', 'Originalparameter', mu);
fprintf('\n%s:   %10.4f', 'ML-Schtzung Xquer', mean(x));
fprintf('\n%s:   %10.4f', 'Gauss-KQ-Schtzung', MU);

