function [thVals] = H0WeibullComb(params, daten)
%
% Funktion H0WeibullComb
%
% [thVals] = H0WeibullComb(params, daten)
%
% Funktion zur Berechnung der Werte der VerteilungsFUNKTION
% einer berlagerung von ZWEI Weibull-Verteilungen
% (Weibull-Mischverteilung) in Abhngigkeit von 
% params = [p, b1, T1, b2, T2] 
%
% Modell:  F(x) = p*fW(b1,T1)+(1-p)*fW(b2,T2)
%
% Eingabeparameter:    daten    Stichprobe der Lnge N
%
%                      params   Werte der Parameter
%                               [p, b1, T1, b2, T2] 
%
% Ausgabeparameter:    thVals   Werte der Verteilungsfunktion
%                               bei den aufsteigend sortierten 
%                               Datenpunkten
%
%
% Es werden sonst KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 28.01.2004


% Zeitparameter der Weibull-Verteilungen

p = params(1);  b1 = params(2);
T1 = params(3); b2 = params(4);
T2 = params(5);

a1 = 1/(T1^b1);           % Anpassung der Parameter auf 
a2 = 1/(T2^b2);           % die MATLAB-Definition


% Sortieren der daten (gleiche Punkte werden NICHT eliminiert)

daten = sort(daten);

% Werte der Verteilungsfunktion an diesen Stellen

thVals = fWeibullComb(daten, [b1, T1, b2, T2], p);