function [hyp, bin] = HypBinBalken(n, N, M)
%
% Funktion HypBibBalken
%
% Aufruf:  [hyp, bin] = HypBinBalken(n, N, M)
%
%
% Diese Funktion bestimmt die Werte der hypergeometrischen Verteilung
% fr die Parameter n, N, M und die Werte der Binomialverteilung fr
% die Parameter n, p=M/(N+M) und plottet diese in Form eines
% Balkendiagramms nebeneinander.
% 
%
% Eingabeparameter:    n, N, M   Verteilungsparameter
%
% Ausgabeparameter:    hyp       Werte der hypergeometrischen Verteilung
%
%                      bin       Werte der Binomialverteilung
%
%
% Es werden KEINE Fehleingaben abgefangen !!
%
% Vorlesung: Mathematik III
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 9.8.2002


% Umcodierung der Parameter in die (anders definierten!)
% Funktionsparameter der Statistics Toolbox-Funktionen

m = N+M; k = M; p = M/(M+N);

% Berechnung der Werte der Verteilung fr k=-2 bis n+2

x = (-2:1:n+2);
hyp = hygepdfB(x,m,k,n);
bin = binopdfB(x,n,p);

% Plot der Werte in Form eines Balkendiagramms

mx = max(max(hyp), max(bin));
subplot(121)
bar(x,hyp); 
set(gca, 'FontSize', 14);
hC = get(gca,'Children');
set(hC, 'FaceColor', [0.50,0.50,0.50])
xlabel('k', 'FontSize', 14); 
ylabel('h_{n,N,M}(k)', 'FontSize', 14);
axis([-2,n+2,0,mx])
subplot(122)
bar(x,bin); 
set(gca, 'FontSize', 14);
hC = get(gca,'Children');
set(hC, 'FaceColor', [0.50,0.50,0.50])
xlabel('k', 'FontSize', 14); 
ylabel('h_{n,p}(k)', 'FontSize', 14);
axis([-2,n+2,0,mx])

