% Script File KolmogorovSmirnovBsp.m
%
% Aufruf:  KolmogorovSmirnovBsp
%
% Beispiel zum Kolmogorov-Smirnov-Test 
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 30.10.2002

% 100 gleichverteilte Daten im Intervall [0,1]

daten = unifrndB(0,1,100,1);

% Werte der Exponentialverteilung im Intervall [0,1]
% berechnen. Parameter lambda = mean(daten)!

lambda = mean(daten);
x = (0:0.01:1)';          % Spaltenvektoren!!
Ecdf = expcdfB(x, lambda);

% Kolmogorov-Smirnov-Test durchfhren

alpha = 0.05;             % Testniveau
tail = 0;                 % zweiseitiger Test

[Ergebnis,p,ksstat,cval] = kstest(daten,[x,Ecdf],alpha,tail)


