% Script File KolmogorovSmirnovLDdaten.m
%
% Aufruf:  KolmogorovSmirnovLDdaten
%
% Beispiel zum Kolmogorov-Smirnov-Test fr den Datensatz
% LDdaten. Es wird getestet, ob die zu Grunde liegende 
% Verteilung eine Weibull-Mischverteilung nach dem Modell
%
% F(x) = p*fW(b1,T1)+(1-p)*fW(b2,T2)
%
% mit den Parametern 
%
%   [p, b1, T1, b2, T2] = [1/4, 3/4, 20, 5, 20]
%
% ist.
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 29.01.2004

% Laden der daten LDdaten.mat

load LDdaten

% Werte der Mischverteilung berechnen

LDdaten = LDdaten(:);      % Spaltenvektoren!!

% Berechnung der theoretischen Verteilungsfunktionswerte
% mit Hilfe von fWeibullComb

params = [3/4, 20, 5, 20];
p = 1/4;
WCombcdf = fWeibullComb(LDdaten, params, p);

% Kolmogorov-Smirnov-Test durchfhren

alpha = 0.05;             % Testniveau
tail = 0;                 % zweiseitiger Test

[Ergebnis,p,ksstat,cval] = ...
    kstestB(LDdaten,[LDdaten,WCombcdf],alpha,tail)


