% Script-File KondensatorNormfit.m
%
% Aufruf:  KondensatorNormfit
%
% Beispiel zur Berechnung von Vertrauensintervallen fr
% normalverteilte Daten mit der MATLAB-Funktion normfit
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 7.07.2002


% Daten der normalverteilten Merkmale
% Gemessene Werte in Werk A:

datA = [100.2   99.7   99.6   99.9    99.9   99.0 ...
         99.9   99.8   99.8   99.6   100.0   99.8 ];

% Gemessene Werte in Werk B:

datB = [100.0   100.1   99.9   99.6   100.0   99.8 ...
        100.4    99.7   99.9   99.9    99.7   99.9];


% Schtzung der Sollwerte und 95%-Vertrauensintervall
% fr Daten aus Werk A

[muA,sigmaA,muVIA] = normfitB(datA,0.05);

% Schtzung der Sollwerte und 95%-Vertrauensintervall
% fr Daten aus Werk B

[muB,sigmaB,muVIB] = normfitB(datB,0.05);

% Ausgabe des Ergebnisses

fprintf('\nSollwertsschtzung Werk A  : %10.4f', muA);
fprintf('\nVertrauensintervall        : [%9.4f,%9.4f]', muVIA);

fprintf('\nSollwertsschtzung Werk B  : %10.4f', muB);
fprintf('\nVertrauensintervall        : [%9.4f,%9.4f]', muVIB);

% Ausschussrate fr die Toleranzgrenzen 99 und 101 (+-1%)
% bei Zugrundelegung der geschtzten Parameter

arA = 100*(normcdfB(99,muA,sigmaA) + (1 - normcdfB(101,muA,sigmaA)))

arB = 100*(normcdfB(99,muB,sigmaB) + (1 - normcdfB(101,muB,sigmaB)))
