% Script-File LsgAufgBootstrp.m
%
% Aufruf:  LsgAufgBootstrp
%
% Lsung einer bung zur Bootstrap-Technik. Schtzung des Modalwertes der Daten
% aus verbrauch.dat mit Hilfe der Statistics Toolbox Funktion bootstrp und der Anpassung
% eines Mischverteilungs-Modells an die Daten.
%
% Zur Modellanpassung wird eine Versionen der Funktion LsgAufgMModal verwendet, die 
% speziell auf die Klasseneinteilung dx = 0.1; und  klmitten = (7.5:dx:11.5);
% zugeschnitten ist. Fr eine flexiblere Gestaltung msste die Datenkommunikation
% ber globale Variable abgewickelt werden, was hier vermieden werden soll.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 4.1.2004


load verbrauch.dat

% Die verwendeten Funktionen sind auf die Klasseneinteilung mit
% dx = 0.1;
% klmitten = (7.5:dx:11.5);    
% abgestimmt !

% Berechnung der Bootstrap-Statistiken mit bootstrp

[ModW, BootSamples] = bootstrpB(length(verbrauch), @MModal2, verbrauch);

% Zweiseitige alpha-Quantile der Modalwerte berechnen

alpha = 0.05;

Gu = prctileB(ModW,100*alpha/2)
Go = prctileB(ModW,100*(1-alpha/2))