function [beta] = LsgAufgMModal(daten, klmitten, beta0)
%
% Aufruf:  [beta] = LsgAufgMModal(daten, klmitten, beta0)
%
% Beispielaufruf: [beta] = LsgAufgMModal(verbrauch, (7.5:0.1:11.5), [1/3, 8.5, 1/3, 10, 1/3])
%
% Funktion zur Anpassung der Dichte einer Mischverteilung zweier Normalverteilungen
% mit den Parametern lambda, mu_1, sigma_1, mu_2, sigma_2 an die empirische
% Verteilung, die sich aus den Daten aus daten und den Klassenmitten aus klmitten
% ergibt.
%
% Eingangsdaten:	  daten      Datenvektor (Stichprobe)
%			          klmitten   gewhlte Klassenmitten
%                     beta0      Anfangswert fr den Parametervektor
%
% Ausgangsdaten:	  params     gefundene Parameter lambda, mu_1, mu_2, 
%                                sigma_1, sigma_2 der Mischverteilung
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 26.12.2003


% Bestimmung der relativen Klassenhufigkeiten fr die
% gewhlte Klasseneinteilung mit Hilfe der Funktion
% distempStetig. Der Parameter Hfg enthlt die absoluten
% Hufigkeiten, aus denen die relativen Klassenhufig-
% keiten in diesem Fall berechnet werden mssen, da in
% emdist die um die Klassenbreite normierten relativen
% Klassenhufigkeiten enthlt

[Hfg, X, emdist, cemdist] = distempStetig(daten, klmitten, 0);

RelH = Hfg/length(daten);
RelH = RelH(:);            % Spaltenvektor
klmitten = klmitten(:);

% Anpassung des Modells mit Hilfe der Funktion nlinfit

[beta,R,J] = nlinfitB(klmitten,RelH,@AufgMModalfun,beta0,klmitten);



