% Script-File LsgQLinRegGalileo.m
%
% Aufruf:  LsgQLinRegGalileo
%
% QUASILINEARE Regression mit Hilfe des Datensatzes galileoExp2.dat.
%
% Es wird ein quadratisches und ein kubisches Modell
% fr ein auf Galileo zurckgehendes Fallexperiment bestimmt. Die erste Spalte
% des Datensatzes galileoExp2.dat enthlt dabei die gemessene Distanz, die
% zweite die Rollhhe der Kugel. Es wir ein Regressionsmodell der ROLLHHE
% in Abhngigkeit von der DISTANZ berechnet.
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 30.11.2003

% Laden des Datensatzes galileoExp2.dat

load galileoExp2.dat
dist = galileoExp2(:,1);
hoeh = galileoExp2(:,2);

% Zahl der Datenpunkte

n = length(dist);

% Quadrate und Kuben der Distanzen

distq = dist.^2; distk = dist.^3;

% Berechnung des quadratischen Modells

X = [ones(length(hoeh),1), dist, distq];
[betaQModell, bintq, rq, rintq, statsq]   = regressB(hoeh,X);


% Berechnung des kubischen Modells

X = [ones(length(hoeh),1), dist, distq, distk];
[betaKModell, bintk, rk, rintk, statsk]   = regressB(hoeh,X);


% Berechnung der Anpassungskurven und Darstellung mit den
% Daten aus galileoExp2.dat

scatter(dist,hoeh, 150, 'r-', 'filled');
xlabel('Distanz/Punkte')
ylabel('Hhe/Punkte')
hold

[dsort, Indx] = sort(dist);       % Daten aufsteigend sortieren

% Distanzen 0, 400 und 2000 fr eine extrapolierte Darstellung
% hinzufgen

dsort = dsort(:); dsort = [0; 400; dsort; 2000];

% Anpassungskurven fr die Modelle berechnen

qmodell = betaQModell(1) + betaQModell(2)*dsort + betaQModell(3)*(dsort.^2);
kmodell = betaKModell(1) + betaKModell(2)*dsort + ...
          betaKModell(3)*(dsort.^2) + betaKModell(4)*(dsort.^3);

% Anpassungskurven dem Scatterplot der Daten hinzufgen

hmin = min([qmodell]); hmax = max([qmodell]);
plot(dsort, qmodell, 'b-', dsort, kmodell, 'k-', 'LineWidth', 3);
axis([0,2000,hmin,hmax])







