function [F, MCPoints] = MCFlaeche(a,b,polygon,N)
%
% Funktion MCFlaeche
%
% Aufruf:  [F, MCPoints] = MCFlaeche(a,b,polygon)
%
% Aufrufbeispiel:    [F, MCPoints] = MCFlaeche(1,1,polygon,100)
%
% Die vorliegende Funktion berechnet, den FLCHENINHALT des durch den Polygonzug
% polygon im Rechteck [0,a]x[0,b] definierten Polygons mit Hilfe der
% MONTE-CARLO-METHODE !!
%
%
% Eingabeparameter: 		    a,b         Seitenlngen des Rechtecks (Werte > 0)
%
%                               ploygon     Polygonzug innerhalb des durch a,b bestimmten
%                                           Rechtecks
%
%                               N           Anzahl(>0) der Zufallspunkte fr die MONTE-CARLO-Berechnung
%
% Ausgabeparameter: 		    F           Schtzung der Polygonflche
%                                       
%                               MCPoints    Berechnete MONTE-CARLO-Punkte und merkt sich,
%                                           ob Treffer oder nicht.
%								
%
% Es werden KEINE Fehleingaben abgefangen !!
%
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 2.11
% Datum: 7.03.2003


% Vorinitialisierungen

Treffer = 0;
if nargout > 1
    MCPoints = [];
end;

rand('state',sum(100*clock));    % Zufallsgenerator initialisieren

for k=1:N                        % Zahl der Iterationen  
                                 % Zufallspunkt im Rechteck [0,a]x[0,b] bestimmen
    X = [a*rand(1,1), b*rand(1,1)];                               
    if nargout > 1               % Punkte merken
        MCPoints = [MCPoints; [X,0]];
    end;
                                 % Prfen, ob er innerhalb des Polygonzugs liegt
    if istDrin(X,a,b,polygon)
        Treffer = Treffer +1;    % falls ja, Trefferzahl erhhen
        if nargout > 1           % Treffer merken
            MCPoints(k,3) = 1; 
        end;
    end;
end;

% Flche berechnen

F = a*b*Treffer/N;

