function [abins, adensity, ualpha, oalpha] = MCNLpADist(N,M,plotten)
%
%
% Aufruf:  [abins, adensity, ualpha, oalpha] = MCNLpADist(N,M,plotten)
%
%
% Die vorliegende Funktion berechnet fr die Makette
%
% A = arctan( (M2+M3)/M1 )
%
% mit Hilfe der MONTE-CARLO-METHODE Schtzwerte fr den Mittelwert
% a von A, dessen Verteilung und die zweiseitigen 95%-Quantile ualpha, oalpha
% fr den Schtzwert!!
% 
% Die Mae M2, M3, M1 sind dabei wie folgt verteilt:
% M3 ist N(0.5, (1/10)^2)-verteilt
% M2 ist gleichverteilt im Intervall [3/8, 5/8]
% M1 ist dreiecksverteilt im Intervall [5/6, 7/6]
%
% Eingabeparameter:    M        Anzahl der Monte-Carlo-Simulationen fr jede
%                               Schtzung von a, die mit der Funktion MCNLpA
%                               durchgefhrt wird.
%
%                      N        Anzahl der Aufrufe von MCNLpA
%
%                      plotten  1, falls ein Histogramm der Schtzungen geplottet
%                               werden soll
%
%
% Ausgabeparameter:    abins    berechnete Klassenmitten (max 50, min 5) fr die
%                               Histogrammdarstellung der Verteilung des Schtzers a
%
%                      adensity Werte der Verteilungsdichte des Schtzers a
%                              (rel. Hufigkeiten in Klasse/M)
%
%                      ualpha   unterer Wert des zweiseitigen 95%-Quantils
%                      oalpha   oberer Wert des zweiseitigen 95%-Quantils
%
%
%
% Es werden sonst KEINE Fehleingaben abgefangen !!
%
% Autor: Prof. Dr. Ottmar Beucher
%        FH Karlsruhe
% Version: 1.01
% Datum: 15.12.2003


a = [];                          % Werte fr die Schtzungen

for k=1:N                        % Zahl der Schtzungen
    [a] = [a, MCNLpA(M)];
end;

% Werte aufsteigend sortieren

a = sort(a);
abins = []; adensity = [];

% Quantile berechnen (Achtung: 2. Parameter in Prozent!)

alpha = 0.05;
ualpha = prctileB(a,100*alpha/2);
oalpha = prctileB(a,100*(1-alpha/2));

if plotten
    % Berechnung des Ergebnisses und Darstellung in Form eines Histogramms

                         % grter Wert zur Festlegung des Darstellungsbereichs
    mBereicho = max(a);
                         % kleinster Wert zur Festlegung des Darstellungsbereichs
    mBereichu = min(a);
                         % Bestimmung der Klassenanzahl und der Klassenmitten
    KlAnz = max(5, floor(sqrt(N)));
    KlAnz = min(KlAnz, 50);
    dx = (mBereicho-mBereichu)/KlAnz;
    abins = (mBereichu+dx/2:dx:mBereichu+KlAnz*dx-dx/2);

                         % Berechnung der Histogrammbalken
    [X, abins, adensity, vFnkt] = distemp3(a, abins, 0);

                         % Plot des Histogramms
    bar(abins, adensity, 0.8);
    set(gca, 'FontSize', 11);
    xlabel('Werte von X');
    ylabel('Rel. Klassenh./dx');
    title(['Histogramm des Schtzers fr a']);
end;